﻿var cawiConnections = {
    context: $(".v-cawiConnections"),
    datatable: null,
    initializeDataTable: function (folder) {
        this.datatable = $(".h-cawiConnections-table", this.context).a4datatable({
            advancedFilter: false,
            height: "full",
            ajaxAction: a4.getProjectAction("GetCAWIConnections", "Diagnostics"),
            columns: [
                { "Title": resources.ServerName, "Data": "ServerName" },
                { "Title": resources.IpAddress, "Data": "IPAddress" },
                { "Title": resources.RecordNo, "Data": "RecordNo" },
                { "Title": resources.ResultCode, "Data": "ResultCode" },
                { "Title": resources.LastQuestion, "Data": "LastQuestion" },
                { "Title": resources.LoginTime, "Data": "LoginTime", "Type": "datetime" },
                { "Title": resources.LogoutTime, "Data": "LogoutTime", "Type": "datetime" }
            ],
            stateKey: "ProjectCAWIConnections",
            localizableTexts: { "All": resources.AllLogs, "Search": resources.SearchLogs },
            quickFilter: {
                "Items": [
                    { "Label": resources.Today, "AjaxParams": { "period": "today" } },
                    { "Label": resources.ThisWeek, "AjaxParams": { "period": "week" } },
                    { "Label": resources.ThisMonth, "AjaxParams": { "period": "month" } },
                    { "Label": resources.Custom, "AjaxParams": { "period": "custom" }, "CustomInputs": [{ "Label": resources.From, "Type": "date", "Key": "period_from" }, { "Label": resources.To, "Type": "date", "Key": "period_to" }] }
                ]
            }
        });
    }
}

$(document).ready(function () {
    if (cawiConnections.context.length > 0) {
        cawiConnections.initializeDataTable();
    }
});